/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.util.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jab125.util.tradehelper.TradeRarities;
import com.jab125.util.tradehelper.type.ITradeType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.hat.gt.GobT;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public abstract class TradeProvider
implements class_2405 {
    private static final Logger LOGGER = GobT.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;
    private Map<class_1299<?>, EnumMap<TradeRarities, List<ITradeType<?>>>> trades = new HashMap();

    protected TradeProvider(class_2403 generator) {
        this.generator = generator;
    }

    protected abstract void registerTrades();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected void registerVanillaTrades() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected final void addTrade(class_1299<?> type, TradeRarities rarity, boolean isVanilla, ITradeType<?> trade) {
        if (isVanilla) {
            return;
        }
        this.addTrade(type, rarity, trade);
    }

    protected final void addTrade(class_1299<?> type, TradeRarities rarity, ITradeType<?> trade) {
        this.trades.putIfAbsent(type, new EnumMap(TradeRarities.class));
        this.trades.get(type).putIfAbsent(rarity, new ArrayList());
        this.trades.get(type).get(rarity).add(trade);
    }

    public void method_10319(class_2408 cache) {
        this.trades.clear();
        this.registerTrades();
        this.trades.forEach((entityType, tradeRarityListEnumMap) -> tradeRarityListEnumMap.forEach((tradeRarity, tradeList) -> {
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            JsonArray tradeArray = new JsonArray();
            tradeList.forEach(trade -> tradeArray.add((JsonElement)trade.serialize()));
            object.add("trades", (JsonElement)tradeArray);
            class_2960 id = Objects.requireNonNull(class_2378.field_11145.method_10221(entityType));
            Path path = this.generator.method_10313().resolve("data/" + id.method_12836() + "/trades/" + id.method_12832() + "/" + tradeRarity.getKey() + ".json");
            try {
                String rawJson = GSON.toJson((JsonElement)object);
                String hash = field_11280.hashUnencodedChars((CharSequence)rawJson).toString();
                if (!Objects.equals(cache.method_10323(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(rawJson);
                    }
                }
                cache.method_10325(path, hash);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save trades to {}", (Object)path, (Object)e);
            }
        }));
    }

    public String method_10321() {
        return "Trades: goblintraders";
    }
}

